local super = require "TableColumn"

RangeBarColumn = super:new()

local defaults = {
    min = 0,
    max = 100,
}

local nilDefaults = {
    'value', 'value2', 'paint',
}

local getterNames = {'min', 'max', 'value', 'value2', 'paint'}

local inspectorInfo = {
    {'KeyArtifact', {'value'}, 'Minimum'},
    {'KeyArtifact', {'value2'}, 'Maximum'},
    {'Range', {min = 'min', max = 'max'}, 'Range'},
    {'Color', {'getPaint:setPaint', custom = 'hasExplicitPaint:'}, 'Color'},
}

function RangeBarColumn:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    self.stamp = RangeBarStamp
    self.getterNames = getterNames
    self.inspectorInfo = inspectorInfo
    
    return self
end

function RangeBarColumn:unarchived()
    local dataset = self:getDataset()
    if dataset then
        if self:getProperty('value') == nil and self:getProperty('value2') == nil then
            local field1 = dataset:pickField('number')
            if field1 then
                local field2 = dataset:pickField('number', { field1 })
                if field2 then
                    self:setProperty('value', KeyArtifact:new(field1))
                    self:setProperty('value2', KeyArtifact:new(field2))
                    self:setTitle(field1 .. '–' .. field2)
                end
            end
        end
    end
    super.unarchived(self)
end

function RangeBarColumn:drawCell(canvas, rect, rangeMin, rangeMax, valueMin, valueMax, paint)
    rect = rect:insetXY(0, rect:height() / 6)
    local parent = self:getParent()
    RangeBarStamp(canvas, rect, rangeMin, rangeMax, valueMin, valueMax, parent:getEmptyFillPaint(), paint or parent:getAccentPaint())
end

function RangeBarColumn:getDefaultPaint()
    return self:getParent():getAccentPaint()
end

return RangeBarColumn
